<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package WordPress
 * @subpackage TRANSLOGIC
 * @since TRANSLOGIC 1.0
 */

// Page (category, tag, archive, author) title

if ( translogic_need_page_title() ) {
	set_query_var('translogic_title_showed', true);
	?>
	<div class="top_panel_title sc_layouts_row">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_center">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title">
						<?php
						// Post meta on the single post
						if ( is_single() )  {
							?><div class="sc_layouts_title_meta"><?php
								translogic_show_post_meta(array(
									'seo' => true,
									'share' => false,
									'counters' => ''
									)
								);
							?></div><?php
						}
						
						// Blog/Post title
						?><div class="sc_layouts_title_title"><?php
							$translogic_blog_title = translogic_get_blog_title();
							$translogic_blog_title_text = $translogic_blog_title_class = $translogic_blog_title_link = $translogic_blog_title_link_text = '';
							if (is_array($translogic_blog_title)) {
								$translogic_blog_title_text = $translogic_blog_title['text'];
								$translogic_blog_title_class = !empty($translogic_blog_title['class']) ? ' '.$translogic_blog_title['class'] : '';
								$translogic_blog_title_link = !empty($translogic_blog_title['link']) ? $translogic_blog_title['link'] : '';
								$translogic_blog_title_link_text = !empty($translogic_blog_title['link_text']) ? $translogic_blog_title['link_text'] : '';
							} else
								$translogic_blog_title_text = $translogic_blog_title;
							?>
							<h1 class="sc_layouts_title_caption<?php echo esc_attr($translogic_blog_title_class); ?>"><?php
								$translogic_top_icon = translogic_get_category_icon();
								if (!empty($translogic_top_icon)) {
									$translogic_attr = translogic_getimagesize($translogic_top_icon);
									?><img src="<?php echo esc_url($translogic_top_icon); ?>" alt="<?php echo esc_attr(basename($translogic_top_icon)); ?>" <?php if (!empty($translogic_attr[3])) translogic_show_layout($translogic_attr[3]);?>><?php
								}
								echo wp_kses($translogic_blog_title_text, 'translogic_kses_content' );
							?></h1>
							<?php
							if (!empty($translogic_blog_title_link) && !empty($translogic_blog_title_link_text)) {
								?><a href="<?php echo esc_url($translogic_blog_title_link); ?>" class="theme_button theme_button_small sc_layouts_title_link"><?php echo esc_html($translogic_blog_title_link_text); ?></a><?php
							}
							
							// Category/Tag description
							if ( is_category() || is_tag() || is_tax() ) 
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
		
						?></div><?php
	
						// Breadcrumbs
						?><div class="sc_layouts_title_breadcrumbs"><?php
							do_action( 'translogic_action_breadcrumbs');
						?></div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
?>