<?php
/**
 * The template to display the widgets area in the header
 *
 * @package WordPress
 * @subpackage TRANSLOGIC
 * @since TRANSLOGIC 1.0
 */

// Header sidebar
$translogic_header_name = translogic_get_theme_option('header_widgets');
$translogic_header_present = !translogic_is_off($translogic_header_name) && is_active_sidebar($translogic_header_name);
if ($translogic_header_present) { 
	translogic_storage_set('current_sidebar', 'header');
	$translogic_header_wide = translogic_get_theme_option('header_wide');
	ob_start();
	if ( is_active_sidebar( $translogic_header_name ) ) {
		dynamic_sidebar( $translogic_header_name );
	}
	$translogic_widgets_output = ob_get_contents();
	ob_end_clean();
	if (trim(strip_tags($translogic_widgets_output)) != '') {
		$translogic_widgets_output = preg_replace("/<\/aside>[\r\n\s]*<aside/", "</aside><aside", $translogic_widgets_output);
		$translogic_need_columns = strpos($translogic_widgets_output, 'columns_wrap')===false;
		if ($translogic_need_columns) {
			$translogic_columns = max(0, (int) translogic_get_theme_option('header_columns'));
			if ($translogic_columns == 0) $translogic_columns = min(6, max(1, substr_count($translogic_widgets_output, '<aside ')));
			if ($translogic_columns > 1)
				$translogic_widgets_output = preg_replace("/class=\"widget /", "class=\"column-1_".esc_attr($translogic_columns).' widget ', $translogic_widgets_output);
			else
				$translogic_need_columns = false;
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo !empty($translogic_header_wide) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<div class="header_widgets_wrap_inner widget_area_inner">
				<?php 
				if (!$translogic_header_wide) { 
					?><div class="content_wrap"><?php
				}
				if ($translogic_need_columns) {
					?><div class="columns_wrap"><?php
				}
				do_action( 'translogic_action_before_sidebar' );
				translogic_show_layout($translogic_widgets_output);
				do_action( 'translogic_action_after_sidebar' );
				if ($translogic_need_columns) {
					?></div>	<!-- /.columns_wrap --><?php
				}
				if (!$translogic_header_wide) {
					?></div>	<!-- /.content_wrap --><?php
				}
				?>
			</div>	<!-- /.header_widgets_wrap_inner -->
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
?>