<?php
/**
 * The template to display posts in widgets and/or in the search results
 *
 * @package WordPress
 * @subpackage TRANSLOGIC
 * @since TRANSLOGIC 1.0
 */

$translogic_post_id    = get_the_ID();
$translogic_post_date  = translogic_get_date();
$translogic_post_title = get_the_title();
$translogic_post_link  = get_permalink();
$translogic_post_author_id   = get_the_author_meta('ID');
$translogic_post_author_name = get_the_author_meta('display_name');
$translogic_post_author_url  = get_author_posts_url($translogic_post_author_id, '');

$translogic_args = get_query_var('translogic_args_widgets_posts');
$translogic_show_date = isset($translogic_args['show_date']) ? (int) $translogic_args['show_date'] : 1;
$translogic_show_image = isset($translogic_args['show_image']) ? (int) $translogic_args['show_image'] : 1;
$translogic_show_author = isset($translogic_args['show_author']) ? (int) $translogic_args['show_author'] : 1;
$translogic_show_counters = isset($translogic_args['show_counters']) ? (int) $translogic_args['show_counters'] : 1;
$translogic_show_categories = isset($translogic_args['show_categories']) ? (int) $translogic_args['show_categories'] : 1;

$translogic_output = translogic_storage_get('translogic_output_widgets_posts');

$translogic_post_counters_output = '';
if ( $translogic_show_counters ) {
	$translogic_post_counters_output = '<span class="post_info_item post_info_counters">'
								. translogic_get_post_counters('comments')
							. '</span>';
}


$translogic_output .= '<article class="post_item with_thumb">';

if ($translogic_show_image) {
	$translogic_post_thumb = get_the_post_thumbnail($translogic_post_id, translogic_get_thumb_size('tiny'), array(
		'alt' => get_the_title()
	));
	if ($translogic_post_thumb) $translogic_output .= '<div class="post_thumb">' . ($translogic_post_link ? '<a href="' . esc_url($translogic_post_link) . '">' : '') . ($translogic_post_thumb) . ($translogic_post_link ? '</a>' : '') . '</div>';
}

$translogic_output .= '<div class="post_content">'
			. ($translogic_show_categories 
					? '<div class="post_categories">'
						. translogic_get_post_categories()
						. $translogic_post_counters_output
						. '</div>' 
					: '')
			. '<h6 class="post_title">' . ($translogic_post_link ? '<a href="' . esc_url($translogic_post_link) . '">' : '') . ($translogic_post_title) . ($translogic_post_link ? '</a>' : '') . '</h6>'
			. apply_filters('translogic_filter_get_post_info', 
								'<div class="post_info">'
									. ($translogic_show_date 
										? '<span class="post_info_item post_info_posted">'
											. ($translogic_post_link ? '<a href="' . esc_url($translogic_post_link) . '" class="post_info_date">' : '') 
											. esc_html($translogic_post_date) 
											. ($translogic_post_link ? '</a>' : '')
											. '</span>'
										: '')
									. ($translogic_show_author 
										? '<span class="post_info_item post_info_posted_by">' 
											. esc_html__('by', 'translogic') . ' ' 
											. ($translogic_post_link ? '<a href="' . esc_url($translogic_post_author_url) . '" class="post_info_author">' : '') 
											. esc_html($translogic_post_author_name) 
											. ($translogic_post_link ? '</a>' : '') 
											. '</span>'
										: '')
									. (!$translogic_show_categories && $translogic_post_counters_output
										? $translogic_post_counters_output
										: '')
								. '</div>')
		. '</div>'
	. '</article>';
translogic_storage_set('translogic_output_widgets_posts', $translogic_output);
?>