@extends($theme.'frontend.layouts.master')
@section('title',__('News'))
@section('content')
    <div class="blog-area pd-top-120 pd-bottom-120">
        <div class="container">
            <div class="row">
                @foreach($news as $data)
                <div class="col-lg-4">
                    <div class="single-blog-inner">
                        <div class="thumb">
                            <img src="{{asset('public/images/news/'.$data->image)}}" alt="img">
                            <span class="date">{{date('d M', strtotime($data->updated_at))}}</span>
                        </div>
                        <div class="details">
                            <ul class="blog-meta">
                                <li><i class="far fa-user"></i> {{__('By Author')}}</li>
                                <li><i class="far fa-clock"></i> {{date('F j, Y', strtotime($data->updated_at))}}</li>
                            </ul>
                            <h3 class="title"><a href="{{route('single.page',['class' => 'news', 'id' =>$data->id])}}">{{__($data->title)}}</a></h3>
                            <p>{!! short_text($data->description, 30) !!}</p>
                            <a class="btn btn-border-gray mt-3" href="{{route('single.page',['class' => 'news', 'id' =>$data->id])}}">{{__('Read More')}} <i class="fa fa-plus"></i></a>
                        </div>
                    </div>
                </div>
                @endforeach
                <div class="pagination text-center">
                    {{$news->links()}}
                </div>
            </div>
        </div>
    </div>
@stop