@extends($theme.'frontend.layouts.master')
@section('title', __('Sceurionpay'))
@section('content')
<div class="contact-area pd-top-120 pd-bottom-120">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8 col-md-8">
                <div class="contact-page-inner bg-black-2 contact-page-inner-cust">
                    <div class="section-title mb-4 pb-2 text-center">
                        <h2 class="title">{{__('Sceurionpay Payment')}} </h2>
                    </div>
                    <form action="{{ route('sceurionpay.ipn')}}" method="post">
                        @csrf
                        <div class="row">
                            <div class="col-md-6">
                                <div class="single-input-inner">
                                    <label>{{__('Name on Card')}} :</label>
                                    <div class="input-group mb-3">
                                        <span class="input-group-text"><i class="fa fa-credit-card"></i></span>
                                        <input class="name form-control" id="the-card-name-id" name="card_name" placeholder="{{__('Enter the name on your card')}}"
                                        autocomplete="off" required>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="single-input-inner">
                                    <label>{{__('Card Number')}} :</label>
                                    <div class="input-group mb-3">
                                        <span class="input-group-text"><i class="fa fa-credit-card"></i></span>
                                        <input class="card-number form-control" name="card_number" placeholder="{{__('Enter your card number')}}"
                                        autocomplete="off" required>
                                    </div>
                                </div>
                            </div>
							<div class='col-xs-12 col-md-4 form-group cvc required'>
								<label class='control-label'>{{__('CVC')}}</label>
                                <div class="input-group mb-3">
                                    <span class="input-group-text"><i class="fa fa-address-card"></i></span>
                                    <input class="cvv form-control" autocomplete="off" class="card-cvc" placeholder="{{__('ex. 311')}}" type="text">
                                </div>
							</div>
							<div class='col-xs-12 col-md-4 form-group expiration required'>
								<label class='control-label'>{{__('Expiration Month')}}</label> 
                                <div class="input-group mb-3">
                                    <span class="input-group-text"><i class="fa fa-calendar"></i></span>
                                    <input class="card-expiry-month form-control" name="expiry_month" placeholder='MM' type='text'>
                                </div>
							</div>
							<div class='col-xs-12 col-md-4 form-group expiration required'>
								<label class='control-label'>{{__('Expiration Year')}}</label> 
								<div class="input-group mb-3">
                                    <span class="input-group-text"><i class="fa fa-calendar"></i></span>
                                    <input class="card-expiry-year form-control" name="expiry_year" placeholder="{{__('YYYY')}}" type="text">
                                </div>
							</div>
                            <div class="col-12 text-center mt-3 mb-3">
                                <button type="submit" class="btn btn-base border-radius-5 pe-5 ps-5">{{__('Pay Now')}}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection