@extends($theme.'frontend.layouts.master')
@section('title',__('Support'))
@section('content')

<div class="transaction-area pd-top-90 pd-bottom-120">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-6 col-lg-8">
                <div class="section-title text-center">
                    <h4 class="title">{{__('Support Ticket')}}</h4>
                </div>
            </div>
        </div>
        <nav class="text-end mb-4">
            <div class="nav nav-tabs transaction-nav-tab d-inline-flex">
                <a href="{{route('customer.new.ticket')}}" class="btn bg-base btn-sm float-end"><i class="fa fa-plus"></i> @lang('New Tickets')</a>
            </div>
        </nav>
        <div class="table-responsive">
            <table class="table transaction-table">
                <thead>
                    <tr>
                        <th>{{__('Sl')}}</th>
                        <th>{{__('Ticket Id')}}</th>
                        <th>{{__('Subject')}}</th>
                        <th>{{__('Raised Time')}}</th>
                        <th>{{__('Status')}}</th>
                        <th>{{__('Action')}}</th>
                    </tr>
                </thead>
                <tbody>
                @foreach($all_support as $key=>$data)
                <tr>
                    <td>{{$key+1}}</td>
                    <td>{{$data->ticket}}</td>
                    <td>{{$data->subject}}</td>
                    <td>{{$data->created_at->format('F dS, Y')}}</td>
                    <td>
                        @if($data->status == 1)
                            <span class="badge bg-warning">{{__('Opened')}}</span>
                        @elseif($data->status == 2)
                            <span class="badge bg-success">{{__('Answered')}}</span>
                        @elseif($data->status == 3)
                            <span class="badge bg-info"> {{__('User Reply')}} </span>
                        @elseif($data->status == 9)
                            <span class="badge bg-danger">  {{__('Closed')}} </span>
                        @endif
                    </td>
                    <td>
                        <a class="btn bg-primary btn-sm" href="{{route('ticket.customer.reply', $data->ticket )}}"><b>{{__('View')}}</b></a>
                    </td>
                </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>

@stop