@extends($theme.'frontend.layouts.master')
@section('title',__('Plan'))
@section('content')

<div class="pricing-area pd-top-120 pd-bottom-90">
    <div class="container">
        <nav class="text-center mb-4">
            <ul class="nav nav-tabs transaction-nav-tab style-2 d-inline-flex" id="myTab" role="tablist">
                @if(count($roi_plans))
                <li class="nav-item m-1" role="presentation">
                    <button class="nav-link active" id="nav-monthly-tab" data-bs-toggle="tab" data-bs-target="#nav-roi" type="button" role="tab" aria-controls="nav-roi" aria-selected="true"> {{__('ROI Investment')}} </button>
                </li>
                @endif
                @if(count($fixed_plans))
                <li class="nav-item m-1" role="presentation">
                    <button class="nav-link" id="nav-yearly-tab" data-bs-toggle="tab" data-bs-target="#nav-fixed" type="button" role="tab" aria-controls="nav-fixed" aria-selected="false">{{__('Fixed Investment')}}</button>
                </li>
                @endif
            </ul>
        </nav>
        <div class="tab-content" id="myTabContent">
            <div class="tab-pane fade show active" id="nav-roi" role="tabpanel" aria-labelledby="nav-monthly-tab">
                <div class="row">
                    @foreach($roi_plans as $data)
                    @php
                        $getTime = \App\Models\ManageTime::where('time', $data->period)->first();
                    @endphp
                    <div class="col-lg-4 col-md-6">
                        <div class="pricing-inner-wrap">
                            <div class="single-pricing-inner style-2">
                                <div class="text-center border-bottom-1 pb-3 mb-4">
                                    <div class="icon">
                                        <img src="{{asset('public/frontend/lightblue/img/icon/34.svg')}}" alt="img">
                                    </div>
                                    <h4>{{__($data->name)}}</h4>
                                </div>
                                <ul>
                                    <li><i class="fa fa-chevron-right"></i> {{__('Minimum Deposit')}} {{$data->min_amount}} {{$general->currency}}</li>
                                    <li><i class="fa fa-chevron-right"></i> {{__('Maximum Deposit')}} {{$data->max_amount}} {{$general->currency}}</li>
                                    <li><i class="fa fa-chevron-right"></i> {{__('ROI Action')}} {{$data->action}} {{__('TIMES')}}</li>
                                    <li><i class="fa fa-chevron-right"></i> {{__('Capital Return')}} @if($data->capital_back_status == 0) 
                                        <span class="badge bg bg-danger">@lang('Off')</span> @else <span class="badge bg bg-success">@lang('On')</span> @endif</li>
                                    <li><i class="fa fa-chevron-right"></i> 
                                        {{$data->percent}}% {{__('Payback')}}
                                        {{trans($getTime->name)}}
                                    </li>
                                </ul>
                                <a class="btn btn-gray w-100 investRoi" data-all="{{$data}}" data-route="{{route('purchase.plan',$data->id)}}" href="#addModal" data-bs-toggle="modal">{{__('Buy Now')}}</a>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
            <div class="tab-pane fade" id="nav-fixed" role="tabpanel" aria-labelledby="nav-yearly-tab">
                <div class="row">
                    @foreach($fixed_plans as $data)
                    @php
                        $getTime = \App\Models\ManageTime::where('time', $data->period)->first();
                    @endphp
                    <div class="col-lg-4 col-md-6">
                        <div class="pricing-inner-wrap">
                            <div class="single-pricing-inner style-2">
                                <div class="text-center border-bottom-1 pb-3 mb-4">
                                    <div class="icon">
                                        <img src="{{asset('public/frontend/lightblue/img/icon/35.svg')}}" alt="img">
                                    </div>
                                    <h4>{{__($data->name)}}</h4>
                                </div>
                                <ul>
                                    <li><i class="fa fa-chevron-right"></i> {{__('Deposit')}} {{$data->fixed_amount}}{{$general->currency}}</li>
                                    <li><i class="fa fa-chevron-right"></i> {{__('ROI Action Lifetime TIMES')}}</li>
                                    <li><i class="fa fa-chevron-right"></i> {{__('Capital Return')}} @if($data->capital_back_status == 0) 
                                        <span class="badge bg bg-danger">@lang('Off')</span> @else <span class="badge bg bg-success">@lang('On')</span> @endif</li>
                                    <li><i class="fa fa-chevron-right"></i> {{$data->percent}}% {{__('Payback')}}
                                        {{trans($getTime->name)}}
                                    </li> 
                                </ul>
                                <a class="btn btn-gray w-100 investFixed" href="#addModalTwo" data-bs-toggle="modal" data-all="{{$data}}" data-route="{{route('purchase.plan',$data->id)}}">{{__('Buy Now')}}</a>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>



<div class="modal fade" id="addModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title text-dark roiTitle"></h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <form id="purPlan" action="" method="POST">
            @csrf
            <div class="modal-body">
                <h6 class="text-success text-center totalGetAmount"></h6>
                <p class="text-primary text-center roiMsg"></p>
                <div class="form-row">
                    <div class="input-group col-md-12">
                        <input type="text" class="form-control" id="investAmount" name="invest_amount" placeholder="{{__('Put Amount for invest')}}" autocomplete="off">
                        <div class="input-group-append">
                            <span class="input-group-text" id="basic-addon2">{{$general->currency}}</span>
                        </div>
                    </div>
                </div>
                <p class="text-danger text-center roiMinMax"></p>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-success submitBtn">{{__('Submit')}}</button>
                <button type="button" class="btn btn-danger" data-bs-dismiss="modal">{{__('Close')}}</button>
            </div>
        </form>
      </div>
    </div>
</div>


<div class="modal fade" id="addModalTwo" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title text-dark fixTitle"></h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <form id="purPlanTwo" action="" method="POST">
            @csrf
            <div class="modal-body">
                <h6 class="text-danger text-center tAmountFix"></h6>
                <h5 class="text-success text-center totalGetAmountFix"></h5>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-success">{{__('Submit')}}</button>
                <button type="button" class="btn btn-danger" data-bs-dismiss="modal">{{__('Close')}}</button>
            </div>
        </form>
      </div>
    </div>
</div>

@endsection
@section('script')
    <script>
        (function($) {
            "use strict";
        $(document).ready(function () {
            $('.submitBtn').css('display','none');
            $('.investFixed').on('click',function () {
                $('#purPlanTwo').attr('action',$(this).data('route'));
                let retuenPerFix = $(this).data('all')['percent'];
                let amtFix = $(this).data('all')['fixed_amount'];
                $('.fixTitle').text($(this).data('all')['name']);
                $('.tAmountFix').text(amtFix+' {{$general->currency}} will deduct from your balance');
                $('.totalGetAmountFix').text('You will get '+retuenPerFix+'% of your Invest for Lifetime');
            });

            $('.investRoi').on('click',function () {
                $('#purPlan').attr('action',$(this).data('route'));
                $('#investAmount').val('');
                getBlank();
                let minAmount = $(this).data('all')['min_amount'];
                let maxAmount = $(this).data('all')['max_amount'];
                let retuenPer = $(this).data('all')['percent'];
                let retuenAction = $(this).data('all')['action'];
                $('.roiTitle').text($(this).data('all')['name']);
                $('.roiMinMax').text('Minimum '+minAmount+' {{$general->currency}} - Maximum '+maxAmount+'{{$general->currency}}');
                $('#investAmount').on('keyup',function () {
                    let invAmount = this.value;
                    if ((parseFloat(invAmount) >= parseFloat(minAmount)) && (parseFloat(invAmount) <= parseFloat(maxAmount))) {
                        let returnAmt = (parseFloat(invAmount)*parseFloat(retuenPer))/100;
                        let totalGetAmount = parseFloat(returnAmt)*parseFloat(retuenAction);
                        $('.roiMsg').text('You will get '+returnAmt+' {{$general->currency}} for '+retuenAction+' times');
                        $('.totalGetAmount').text('You will get total '+totalGetAmount+' {{$general->currency}} after complete ROI');
                        $('.submitBtn').css('display','block');
                    }else {
                        $('.submitBtn').css('display','none');
                        getBlank();
                    }
                })
            });
            function getBlank() {
                $('.roiMsg').text('');
                $('.totalGetAmount').text('');
            }
        });
        })(jQuery);
    </script>
@endsection
