<?php $__env->startSection('title',__('2FA Authentication')); ?>
<?php $__env->startSection('content'); ?>
<div class="contact-area pd-top-90 pd-bottom-120">
    <div class="container">
        <div class="row justify-content-left">
            <div class="col-lg-6">
                <div class="contact-page-inner bg-black-2 contact-page-inner-cust">
                <?php if(Auth::user()->tauth == '1'): ?>
                    <form>
                        <div class="title text-center">
                            <h5><?php echo e(__('QR Code')); ?></h5>
                        </div>
                        
                        <div class="form-group text-center">
                            <img src="<?php echo e($prevqr); ?>">
                        </div>
                        <div class="col-12 text-center mt-3 mb-3">
                            <button type="button" class="btn btn-danger border-radius-5 pe-5 ps-5" data-bs-toggle="modal" data-bs-target="#disableModal"><?php echo e(__('Disable Two Factor Authenticator')); ?></button>
                        </div>
                    </form>
                <?php else: ?>
                    <form>
                        <div class="title text-center">
                            <h5><?php echo e(__('QR Code')); ?></h5>
                        </div>
                        <div class="form-group text-center">
                            <img src="<?php echo e($qrCodeUrl); ?>">
                        </div>
                        <div class="col-12 text-center mt-3 mb-3">
                            <button type="button" class="btn btn-success border-radius-5 pe-5 ps-5" data-bs-toggle="modal" data-bs-target="#enableModal"><?php echo e(__('Enable Two Factor Authenticator')); ?></button>
                        </div>
                    </form>
                <?php endif; ?>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="contact-page-inner bg-black-2 contact-page-inner-cust">
                    <form>
                        <div class="title text-center">
                            <h5><?php echo e(__('Authenticator')); ?></h5>
                        </div>
                        <div class="part-text">
                            <h5><?php echo e(__('Use Google Authenticator to Scan the QR code  or use the code')); ?></h5><hr/>
                        </div>
                        <div class="part-text">
                            <p><?php echo e(__('Google Authenticator is a multifactor app for mobile devices. It generates timed codes used during the 2-step verification process. To use Google Authenticator, install the Google Authenticator application on your mobile device.')); ?></p>
                        </div>
                        <div class="col-12 text-center mt-3 mb-3">
                            <a type="submit" href="https://play.google.com/store/apps/details?id=com.google.android.apps.authenticator2&hl=en" target="_blank" class="btn btn-base border-radius-5 pe-5 ps-5"><?php echo e(__('DOWNLOAD APP')); ?></a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="enableModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title text-white" id="exampleModalLabel"><?php echo e(__('Verify Your OTP')); ?></h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <form method="post" action="<?php echo e(route('go2fa.create')); ?>">
            <?php echo csrf_field(); ?>
            <div class="modal-body">
                <div class="form-group">
                    <input type="hidden" name="key" value="<?php echo e($secret); ?>">
                    <input type="text" class="form-control" name="code" placeholder="<?php echo e(__('Enter Google Authenticator Code')); ?>">
                </div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-success"><?php echo e(__('Verify')); ?></button>
                <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
            </div>
        </form>
      </div>
    </div>
</div>

<div class="modal fade" id="disableModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title text-white" id="exampleModalLabel"><?php echo e(__('Verify Your OTP to Disable')); ?></h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <form method="post" action="<?php echo e(route('disable.2fa')); ?>">
            <?php echo csrf_field(); ?>
            <div class="modal-body">
                <div class="form-group">
                    <input type="text" class="form-control" name="code" placeholder="<?php echo e(__('Enter Google Authenticator Code')); ?>">
                </div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-success"><?php echo e(__('Verify')); ?></button>
                <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
            </div>
        </form>
      </div>
    </div>
</div>


<?php $__env->stopSection(); ?>
<?php echo $__env->make($theme.'frontend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/metrqiuu/public_html/resources/views/theme/deepblack/frontend/goauth/create.blade.php ENDPATH**/ ?>