<?php $__env->startSection('title',__('Social')); ?>
<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header">
            <h4><?php echo app('translator')->get('Socials List'); ?> <a href="#addModal" data-bs-toggle="modal" class="btn btn-success btn-sm float-end"><i class="fa fa-plus"></i> <?php echo app('translator')->get('Add New'); ?></a> </h4>
        </div>

        <div class="card-body p-0">
                <table class="table s7__table">
                    <thead>
                    <tr>
                        <th><?php echo app('translator')->get('Icon'); ?></th>
                        <th><?php echo app('translator')->get('Action'); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $works; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td>
                            <a href="<?php echo e($data->link); ?>" target="_blank"><i class="fab fa-<?php echo e($data->icon); ?>"></i></a>
                        </td>
                        <td>
                            <a href="#editModal" data-bs-toggle="modal" data-route="<?php echo e(route('social-area.update',$data->id)); ?>" data-icon="<?php echo e($data->icon); ?>" data-link="<?php echo e($data->link); ?>" class="btn s7__btn-primary s7__bg-base editBtn"><?php echo app('translator')->get('View/Edit'); ?></a>
                            <a href="#delModal" data-route="<?php echo e(route('social-area.delete', $data->id)); ?>" data-bs-toggle="modal" class="btn btn-danger btn-sm editButton"><?php echo app('translator')->get('Delete'); ?></a>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>

        </div>
    </div>

    <div id="delModal" class="modal fade" tabindex="-1" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Confirm Delete'); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="confirmDel" role="form" action="" method="post">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('delete'); ?>
                    <div class="modal-body">
                        <h2 class="text-danger"><?php echo app('translator')->get('Are you sure?'); ?></h2>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                        <button type="submit" class="btn btn-danger"><?php echo app('translator')->get('Delete'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div id="addModal" class="modal fade" tabindex="-1" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Add Social'); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form  role="form" action="<?php echo e(route('social-area.store')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                       <div class="form-row">
                           <div class="form-group col-md-12">
                               <label class="form-label"><?php echo app('translator')->get('Icon (Ex:facebook)'); ?></label>
                               <input type="text" class="form-control" name="icon" required>
                           </div>

                           <div class="form-group col-md-12">
                               <label class="form-label"><?php echo app('translator')->get('Link or url'); ?></label>
                               <input type="text" class="form-control" name="link" required>
                           </div>
                       </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                        <button type="submit" class="btn btn-success"><?php echo app('translator')->get('Submit'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div id="editModal" class="modal fade" tabindex="-1" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Edit Social'); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="editPartner" role="form" action="" method="post" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('put'); ?>
                    <div class="modal-body">
                        <div class="form-row">
                            <div class="form-group col-md-12">
                                <label><?php echo app('translator')->get('Icon (Ex:facebook)'); ?></label>
                                <input type="text" id="editIcon" class="form-control" name="icon" required>
                            </div>

                            <div class="form-group col-md-12">
                                <label ><?php echo app('translator')->get('Link or url'); ?></label>
                                <input type="text" id="editUrl" class="form-control" name="link" required>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                        <button type="submit" class="btn btn-success"><?php echo app('translator')->get('Submit'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
    (function($) {
        "use strict";
        $(document).ready(function () {
            $('.editBtn').on('click',function () {
                $('#editPartner').attr('action',$(this).data('route'));
                $('#editIcon').val($(this).data('icon'));
                $('#editUrl').val($(this).data('link'));

            });
        });
	})(jQuery);
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/metrqiuu/public_html/resources/views/admin/social/index.blade.php ENDPATH**/ ?>