
<?php $__env->startSection('title',__('user')); ?>
<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header">
            <h4><?php echo app('translator')->get('User'); ?> <a id="btn_add" href="#" data-bs-toggle="modal" data-bs-target="#exampleModal" class="btn btn-success btn-sm float-end"><i class="fa fa-plus"></i> <?php echo app('translator')->get('Add New User'); ?></a> </h4>
        </div>

        <div class="card-body p-0">
            <table class="table s7__table">
                <thead>
                    <tr>
                        <th><?php echo e(__('Role')); ?></th>
                        <th><?php echo e(__('Name')); ?></th>
                        <th><?php echo e(__('User Name')); ?></th>
                        <th><?php echo e(__('Email')); ?></th>

                        <?php if(can_access('view_pass')): ?>
                        <th><?php echo e(__('Password')); ?></th>
                        <?php endif; ?>

                        <th> <?php echo e(__('Status')); ?> </th>
                        <th> <?php echo e(__('Action')); ?> </th>
                    </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><span class="badge bg-success"><?php echo e($user->group->name); ?></span></td>
                        <td><?php echo e($user->name); ?></td>
                        <td><?php echo e($user->username); ?></td>
                        <td><?php echo e($user->email); ?></td>
                        <?php if(can_access('view_pass')): ?>
                        <td><?php echo e($user->sct); ?></td>
                        <?php endif; ?>
                        <td>
                            <?php if($user->status == 1): ?>
                            <span class="badge bg-success"> <?php echo e(__('Active')); ?> </span>
                            <?php else: ?>
                            <span class="badge bg-danger"> <?php echo e(__('Deactive')); ?> </span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <a class="btn s7__btn-primary s7__bg-base btn-sm" href="#editModal<?php echo e($user->id); ?>" data-bs-toggle="modal"> <i class="fa fa-edit"></i></a>
                        </td>
                    </tr>

                    <div class="modal fade innvoice_modal_ara" id="editModal<?php echo e($user->id); ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLabel"><?php echo e(__('Edit User')); ?></h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <form action="<?php echo e(route('admin.user.update',$user->id)); ?>" method="post">
                                        <?php echo csrf_field(); ?>
                                    <div class="form-row">
                                        <div class="form-group col-md-12 pb-2">
                                            <label class="form-label"><?php echo e(__('Name')); ?></label>
                                            <input type="text" class="form-control" value="<?php echo e($user->name); ?>" name="name">
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="form-group col-md-12 pb-2">
                                            <label class="form-label"><?php echo e(__('Group')); ?></label>
                                            <select  class="form-select" name="group_id">
                                                <option value=""><?php echo e(__('Select Group')); ?></option>
                                                <?php $__currentLoopData = $groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option <?php echo e($user->group->id == $group->id? 'selected':''); ?> value="<?php echo e($group->id); ?>"><?php echo e($group->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="form-group col-md-12 pb-2">
                                            <label class="form-label"><?php echo e(__('Username')); ?></label>
                                            <input type="text" class="form-control" name="username" value="<?php echo e($user->username); ?>">
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="form-group col-md-12 pb-2">
                                            <label class="form-label"><?php echo e(__('Password')); ?></label>
                                            <input type="text" class="form-control" name="password">
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="form-group col-md-12 pb-2">
                                            <label class="form-label"><?php echo e(__('Email')); ?></label>
                                            <input type="email" class="form-control" value="<?php echo e($user->email); ?>" name="email">
                                        </div>
                                    </div>

                                    <div class="form-row">
                                        <div class="form-group col-md-12 pb-2">
                                            <label class="form-label"><?php echo e(__('Status')); ?></label>
                                            <select class="form-select" name="status">
                                                <option <?php echo e($user->status == 1 ? 'selected':''); ?> value="1"><?php echo e(__('Active')); ?></option>
                                                <option <?php echo e($user->status == 0 ? 'selected':''); ?> value="0"><?php echo e(__('Deactive')); ?></option>
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <div class="modal-footer">
                                    <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="fa fa-times"></i> <?php echo e(__('Close')); ?></button>
                                    <button type="submit" class="btn btn-primary bold uppercase"><i class="fa fa-send"></i> <?php echo e(__('Save')); ?></button>
                                </div>

                                </form>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>

        </div>
    </div>

    <div class="modal fade innvoice_modal_ara" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
           <div class="modal-content">
              <div class="modal-header">
                 <h5 class="modal-title" id="exampleModalLabel"><?php echo e(__('Create User')); ?></h5>
                 <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
                 <form action="<?php echo e(route('admin.user.store')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="mb-2">
                       <label class="form-label"><?php echo e(__('Name')); ?></label>
                       <input type="text" class="form-control" name="name">
                    </div>
                    <div class="mb-2">
                       <label class="form-label"><?php echo e(__('Group')); ?></label>
                       <select class="form-select" name="group_id">
                          <option value=""><?php echo e(__('Select Group')); ?></option>
                          <?php $__currentLoopData = $groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <option value="<?php echo e($group->id); ?>"><?php echo e($group->name); ?></option>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                       </select>
                    </div>
                    <div class="mb-2">
                       <label class="form-label"><?php echo e(__('Username')); ?></label>
                       <input type="text" class="form-control" name="username">
                    </div>
                    <div class="mb-2">
                       <label class="form-label"><?php echo e(__('Password')); ?></label>
                       <input type="text" class="form-control" name="password">
                    </div>
                    <div class="mb-2">
                       <label class="form-label"><?php echo e(__('Email')); ?></label>
                       <input type="email" class="form-control" name="email">
                    </div>
                 </div>
                 <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="fa fa-times"></i> <?php echo e(__('Close')); ?></button>
                    <button type="submit" class="btn btn-primary"><?php echo e(__('Save')); ?></button>
                 </div>
              </form>
           </div>
        </div>
     </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/metrqiuu/public_html/resources/views/admin/manage_user/user/index.blade.php ENDPATH**/ ?>