
<?php $__env->startSection('title',__('Wallets')); ?>
<?php $__env->startSection('content'); ?>
<div class="transaction-area pd-top-90 pd-bottom-120">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-6 col-lg-8">
                <div class="section-title text-center">
                    <h4 class="title"><?php echo e(__('WALLET ADDRESSES')); ?></h4>
                </div>
            </div>
        </div>
        <nav class="text-end mb-4">
            <div class="nav nav-tabs transaction-nav-tab d-inline-flex">
                <a href="#addwallet" data-bs-toggle="modal" class="btn bg-base btn-sm float-end"><i class="fa fa-plus"></i> <?php echo app('translator')->get('New Wallet'); ?></a>
            </div>
        </nav>
        <div class="table-responsive">
            <table class="table transaction-table">
                <thead>
                    <tr>
                        <th><?php echo e(__('Name')); ?></th>
                        <th><?php echo e(__('Wallet Address')); ?></th>
                        <th><?php echo e(__('Balance')); ?></th>
                    </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $wallet; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($item->wallet_name); ?></td>
                    <td><?php echo e($item->address); ?></td>
                    <td><?php echo e(number_format($item->balance,8)); ?> <?php echo e($general->cp_currency); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <nav class="text-start mb-4">
            <div class="nav nav-tabs transaction-nav-tab">
                <a href="#addwalletsend" data-bs-toggle="modal" class="btn btn-primary wallet-cust btn-sm"><i class="fa fa-upload" aria-hidden="true"></i> <?php echo app('translator')->get('Send'); ?></a>
                <a href="#addwalletreceived" data-bs-toggle="modal" class="btn btn-info btn-sm"><i class="fa fa-download" aria-hidden="true"></i> <?php echo app('translator')->get('Receive'); ?></a>
            </div>
        </nav>
    </div>
</div>


<div class="modal fade" id="addwallet" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title text-white fixTitle"><?php echo e(__('Create New Wallet')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="<?php echo e(route('new-wallet.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="row">
                        <div class="form-group">
                            <label class="text-white" for="investAmount"><?php echo e(__('Wallet Name')); ?></label>
                            <input type="text" class="form-control" id="investAmount" name="wallet_name" placeholder="<?php echo e(__('Optional.Eg: My Wallet')); ?>" autocomplete="off">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success"><?php echo e(__('Submit')); ?></button>
                    <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>


<div class="modal fade" id="addwalletsend" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title text-white fixTitle"><?php echo e(__('Send')); ?> <?php echo e($general->cp_currency); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="purPlanTwo" action="<?php echo e(route('purchase-coin-send.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="form-group mb-2">
                        <label class="text-white"><?php echo e(__('Send From')); ?></label>
                        <select class="form-select" aria-label="Default select example" name="from_wallet_id" id="fromad">
                        <?php $__currentLoopData = $wallet; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($item->id); ?>"><?php echo e($item->wallet_name); ?> | <?php echo e($item->address); ?> | <?php echo e($item->balance); ?> <?php echo e($general->cp_currency); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="form-group mb-2">
                        <label class="text-white"><?php echo e(__('To')); ?></label>
                        <input type="text" name="to_wallet_id" id="toadd" class="form-control input-sz" placeholder="Enter Recipient Wallet Address" required="">
                    </div>
                    <div class="form-group mb-2">
                        <label class="text-white"><?php echo e(__('Amount')); ?></label>
                        <div class="input-group">
                            <input type="text" name="coin_amount" class="form-control" id="amount" required>
                            <span class="input-group-text" id="basic-addon2"><?php echo e($general->cp_currency); ?></span>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success"><?php echo e(__('Send')); ?></button>
                    <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="addwalletreceived" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title text-white fixTitle"><?php echo e(__('Receive')); ?> <?php echo e($general->cp_currency); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="purPlanTwo" action="<?php echo e(route('purchase-coin-receive.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="form-group mb-2">
                        <label class="text-white"><?php echo e(__('Sender Wallet Address')); ?></label>
                        <input type="text" name="to_wallet_id" id="toadd" class="form-control input-sz" placeholder="Enter Recipient Wallet Address" required="">
                    </div>
                    <div class="form-group mb-2">
                        <label class="text-white"><?php echo e(__('Receive Wallet Address')); ?></label>
                        <select class="form-select" aria-label="Default select example" name="from_wallet_id" id="fromad">
                            <?php $__currentLoopData = $wallet; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($item->id); ?>"><?php echo e($item->wallet_name); ?> | <?php echo e($item->address); ?> | <?php echo e($item->balance); ?> <?php echo e($general->cp_currency); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="form-group mb-2">
                    <label class="text-white"><?php echo e(__('Amount')); ?></label>
                        <div class="input-group">
                            <input type="text" name="coin_amount" class="form-control" id="amount" required>
                            <span class="input-group-text" id="basic-addon2"><?php echo e($general->cp_currency); ?></span>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success"><?php echo e(__('Submit')); ?></button>
                    <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make($theme.'frontend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/metrqiuu/public_html/resources/views/theme/deepblack/user/wallet/wallet.blade.php ENDPATH**/ ?>