<?php $__env->startSection('title',__('Plan Edit')); ?>
<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body">
            <form action="<?php echo e(route('plan-area.update',$workArea->id)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('put'); ?>

                <div class="row mb-2">
                    <div class="form-group col-md-4">
                        <label class="form-label"><?php echo app('translator')->get('Plan Name'); ?></label>
                        <input type="text" class="form-control" name="name" value="<?php echo e($workArea->name); ?>" required>
                    </div>

                    <div class="form-group col-md-4">
                        <label class="form-label"><?php echo app('translator')->get('Plan Type'); ?></label>
                        <select name="return_time_status" id="planType" class="form-select">
                            <option disabled  value=""><?php echo app('translator')->get('Choose One'); ?></option>
                            <option <?php echo e($workArea->return_time_status == 1? 'selected' : ''); ?> value="1"><?php echo app('translator')->get('ROI Invest'); ?></option>
                            <option <?php echo e($workArea->return_time_status == 0? 'selected' : ''); ?> value="0"><?php echo app('translator')->get('Fixed Invest'); ?></option>
                        </select>
                    </div>

                    <div class="form-group col-md-4">
                        <label><?php echo app('translator')->get('Capital Back Status'); ?></label>
                        <select name="capital_back_status" class="form-select">
                            <option disabled selected value=""><?php echo app('translator')->get('Choose One'); ?></option>
                            <option <?php echo e($workArea->capital_back_status == 0? 'selected' : ''); ?> value="0"><?php echo app('translator')->get('Capital Not Back'); ?></option>
                            <option <?php echo e($workArea->capital_back_status == 1? 'selected' : ''); ?> value="1"><?php echo app('translator')->get('Capital Back'); ?></option>
                        </select>
                    </div>
                </div>

                <div class="row mb-2">
                    <div class="form-group col-md-6">
                        <label class="form-label"><?php echo app('translator')->get('Return Percentage'); ?></label>
                        <input type="text" class="form-control" name="percent" required value="<?php echo e($workArea->percent); ?>">
                    </div>

                    <div class="form-group col-md-6">
                        <label class="form-label"><?php echo app('translator')->get('Return Period'); ?></label>
                        <select name="period" class="form-select" required>
                            <option value="" disabled><?php echo app('translator')->get('Select a Period'); ?></option>
                            <?php $__currentLoopData = $times; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($item->time); ?>"
                                    <?php echo e(old('schedule', $workArea->period) == $item->time ? 'selected' : ''); ?>>
                                    <?php echo app('translator')->get('Every'); ?> <?php echo e($item->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
                <div class="roiInvest mb-2">
                    <div class="row">
                        <div class="form-group col-md-6">
                            <label class="form-label"><?php echo app('translator')->get('Minimum Amount'); ?></label>
                            <input type="text" class="form-control" value="<?php echo e($workArea->min_amount); ?>" name="min_amount">
                        </div>

                        <div class="form-group col-md-6 mb-2">
                            <label class="form-label"><?php echo app('translator')->get('Maximum Amount'); ?></label>
                            <input type="text" class="form-control" name="max_amount" value="<?php echo e($workArea->max_amount); ?>">
                        </div>

                        <div class="form-group col-md-6">
                            <label class="form-label"><?php echo app('translator')->get('Return Action (How many time)'); ?></label>
                            <input type="number" class="form-control" name="action" value="<?php echo e($workArea->action); ?>">
                        </div>
                    </div>
                </div>
                <div class="fixedInvest mb-2">
                    <div class="row">
                        <div class="form-group col-md-6">
                            <label class="form-label"><?php echo app('translator')->get('Fixed Amount (Return Action #Liftime)'); ?></label>
                            <input type="text" class="form-control" name="fixed_amount" value="<?php echo e($workArea->fixed_amount); ?>">
                        </div>
                    </div>
                </div>
                <div class="text-center">
                    <button type="submit" class="btn s7__btn-primary s7__bg-base mt-2"><?php echo app('translator')->get('Update'); ?></button>
                </div>
            </form>
        </div>
    </div>
    <input type="hidden" id="return_time_status" value="<?php echo e($workArea->return_time_status); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script src="https://code.jquery.com/jquery-2.2.4.min.js" integrity="sha256-BbhdlvQf/xTY9gja0Dq3HiwQF8LaCRTXxZKRutelT44=" crossorigin="anonymous"></script>
    <script>
        (function($) {
            "use strict";
            $(window).load(function() {

                var myReturnTime = $('#return_time_status').val();

                makeAction(''+myReturnTime+'');
                console.log(makeAction);
            });
            $(document).ready(function () {
                $('#planType').on('change',function () {
                    makeAction(this.value);
                });
            });
            function makeAction(value) {
                if (value == 1){
                    $('.fixedInvest').css('display','none');
                    $('.roiInvest').css('display','block');
                }
                if (value == 0){
                    $('.roiInvest').css('display','none');
                    $('.fixedInvest').css('display','block');
                }
            }
        })(jQuery);
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/metrqiuu/public_html/resources/views/admin/plan/edit.blade.php ENDPATH**/ ?>