<?php $__env->startSection('title',__('Deposit History')); ?>
<?php $__env->startSection('content'); ?>
<div class="transaction-area pd-top-90 pd-bottom-120">
    <div class="container">
        <div class="table-responsive">
            <table class="table transaction-table">
                <thead>
                    <tr>
                        <th><?php echo e(__('Gateway Name')); ?></th>
                        <th><?php echo e(__('Amount')); ?></th>
                        <th><?php echo e(__('Charge')); ?></th>
                        <th><?php echo e(__('USD Amount')); ?></th>
                        <th><?php echo e(__('Status')); ?></th>
                        <th><?php echo e(__('Transaction ID')); ?></th>
                        <th><?php echo e(__('Time')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deposit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td data-label="Email"><?php echo e(($deposit->gateway->main_name)?$deposit->gateway->main_name:$deposit->gateway->name); ?></td>
                        <td data-label="Username"><?php echo e(round($deposit->amount, 8)); ?> <?php echo e($general->currency); ?></td>
                        <td data-label="Mobile"><?php echo e(round($deposit->charge, 8)); ?> <?php echo e($general->currency); ?></td>
                        <td data-label="Balance"><?php echo e(round($deposit->usd_amo, 8)); ?> <?php echo e(__('USD')); ?></td>
                        <?php if(isset($deposit->deposit_request_table) && !is_null($deposit->deposit_request_table)): ?>
                            <?php if($deposit->deposit_request_table->accepted == 0): ?>
                                <td data-label="Balance"><span class="badge bg-warning text-dark"><?php echo e(__('pending')); ?></span></td>
                                <?php elseif($deposit->deposit_request_table->accepted == 1): ?>
                                <td data-label="Balance"><span class="badge bg-success"><?php echo e(__('complete')); ?></span></td>
                                <?php else: ?>
                                    <td data-label="Balance"><span class="badge bg-danger"><?php echo e(__('rejected')); ?></span></td>
                                <?php endif; ?>
                            <?php else: ?>
                            <td data-label="Balance"><?php echo e(($deposit->status==0)?'incomplete':'complete'); ?></td>
                        <?php endif; ?>
                        <td  data-label="Details"><?php echo e($deposit->trx); ?></td>
                        <td  data-label="Time"><?php echo e($deposit->updated_at->format('d/m/y  h:i A')); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
            <div class="row">
                <div class="col-md-12 text-center">
                    <?php echo e($deposits->links()); ?>

                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($theme.'frontend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/metrqiuu/public_html/resources/views/theme/deepblack/user/deposit/log.blade.php ENDPATH**/ ?>