<?php $__env->startSection('title',__('Settings')); ?>
<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-body">
        <form class="form-cont" action="<?php echo e(route('general.store')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="row">
                <div class="col-md-4">
                    <label class="form-label"><?php echo app('translator')->get('Website Name'); ?></label>
                    <div class="input-group">
                        <input type="text" class="form-control" name="web_name" value="<?php echo e($general->web_name); ?>">
                    </div>
                </div>
                <div class="col-md-4">
                    <label class="form-label"><?php echo app('translator')->get('Website Currency (Ex: USD, EURO)'); ?></label>
                    <div class="input-group">
                        <input type="text" class="form-control" name="currency" value="<?php echo e($general->currency); ?>">
                    </div>
                </div>
                <div class="col-md-4">
                    <label class="form-label"><?php echo app('translator')->get('Color Code (Note: Do not use "#")'); ?></label>
                    <div class="input-group">
                        <input type="text" class="form-control" name="color_code" value="<?php echo e($general->color_code); ?>">
                    </div>
                </div>
                <div class="form-group col-md-4">
                    <label class="font-weight-bold"><?php echo app('translator')->get('Paginate Per Page'); ?></label>
                    <input type="text" name="paginate" value="<?php echo e(old('paginate') ?? $general->paginate ?? '2'); ?>"
                            required="required" class="form-control ">
                </div>
                <div class="col-md-4">
                    <label class="form-label"><?php echo app('translator')->get('Fixed Charge (Balance Transfer)'); ?></label>
                    <div class="input-group">
                        <input type="text" class="form-control" name="bal_trans_fixed_charge" value="<?php echo e($general->bal_trans_fixed_charge); ?>">
                    </div>
                </div>
                <div class="col-md-4">
                    <label class="form-label"><?php echo app('translator')->get('Percentage (%) Charge (Balance Transfer)'); ?></label>
                    <div class="input-group">
                        <input type="text" class="form-control" name="bal_trans_percentage_charge" value="<?php echo e($general->bal_trans_percentage_charge); ?>">
                    </div>
                </div>
                <div class="col-md-4">
                    <label class="form-label"><?php echo app('translator')->get('Contact Email'); ?></label>
                    <div class="input-group">
                        <input type="email" class="form-control" name="contact_email" value="<?php echo e($general->contact_email); ?>">
                    </div>
                </div>
                <div class="col-md-4">
                    <label class="form-label"><?php echo app('translator')->get('Contact Phone'); ?></label>
                    <div class="input-group">
                        <input type="text" class="form-control" name="contact_phone" value="<?php echo e($general->contact_phone); ?>">
                    </div>
                </div>
                <div class="col-md-4">
                    <label class="form-label"><?php echo app('translator')->get('Contact Address'); ?></label>
                    <div class="input-group">
                        <input type="text" class="form-control" name="contact_address" value="<?php echo e($general->contact_address); ?>">
                    </div>
                </div>
                <div class="form-group col-md-4">
                    <label class="font-weight-bold"><?php echo app('translator')->get('Minimum Transfer'); ?></label>
                    <input type="text" name="min_transfer" value="<?php echo e(old('min_transfer') ?? $general->min_transfer ?? '1'); ?>"
                            required="required" class="form-control ">
                </div>

                <div class="form-group col-md-4">
                    <label class="font-weight-bold"><?php echo app('translator')->get('Maximum Transfer'); ?></label>
                    <input type="text" name="max_transfer" value="<?php echo e(old('max_transfer') ?? $general->max_transfer ?? '1000'); ?>"
                            required="required" class="form-control ">
                </div>
                <div class="form-group col-md-4">
                    <label class="font-weight-bold"><?php echo app('translator')->get('Bonus Amount'); ?></label>
                    <div class="input-group mb-3">
                        <input type="text" name="bonus_amount" value="<?php echo e(old('bonus_amount') ?? $general->bonus_amount ?? '0'); ?>"
                                required="required" class="form-control">
                            <span class="input-group-text" ><?php echo e(trans($general->currency)); ?></span>
                    </div>
                </div>
                <div class="col-md-6">
                    <label class="form-label"><?php echo app('translator')->get('CopyRight Text'); ?></label>
                    <div class="input-group">
                        <textarea class="form-control" name="copyright_text" id="" cols="30" rows="5"><?php echo e($general->copyright_text); ?></textarea>
                    </div>
                </div>
                <div class="col-md-6 mb-2">
                    <label class="form-label"><?php echo app('translator')->get('Comment Script'); ?></label>
                    <div class="input-group">
                        <textarea class="form-control" name="comment_script" id="" cols="30" rows="5"><?php echo e($general->comment_script); ?></textarea>
                    </div>
                </div>
                <div class="col-md-6 mb-2">
                    <label class="form-label"><?php echo app('translator')->get('Live Chat Script'); ?></label>
                    <div class="input-group">
                        <textarea class="form-control" name="livechat_script" id="" cols="30" rows="5"><?php echo e($general->livechat_script); ?></textarea>
                    </div>
                </div>
                <div class="col-md-6 mb-2">
                    <div class="form-group">
                        <label class="form-label"><?php echo app('translator')->get('Footer Text'); ?></label>
                        <textarea class="form-control" name="footer_text"cols="30" rows="5"><?php echo e($general->footer_text); ?></textarea>
                    </div>
                </div>

                <div class="col-md-4">
                    <label class="form-label"><?php echo app('translator')->get('Days Wise Cron Payment'); ?></label>
                    <div class="input-group">
                        <select class="form-select days_cron" aria-label="multiple select example" multiple="multiple" name="date_wise_action[]" required>
                            <option value="Sat" <?php echo e(is_array(json_decode($general->date_wise_action)) && in_array("Sat", json_decode($general->date_wise_action))? 'selected' : ''); ?>>Saturday</option>
                            <option value="Sun" <?php echo e(is_array(json_decode($general->date_wise_action)) && in_array("Sun", json_decode($general->date_wise_action))? 'selected' : ''); ?>>Sunday</option>
                            <option value="Mon" <?php echo e(is_array(json_decode($general->date_wise_action)) && in_array("Mon", json_decode($general->date_wise_action))? 'selected' : ''); ?>>Monday</option>
                            <option value="Tue" <?php echo e(is_array(json_decode($general->date_wise_action)) && in_array("Tue", json_decode($general->date_wise_action))? 'selected' : ''); ?>>Tuesday</option>
                            <option value="Wed" <?php echo e(is_array(json_decode($general->date_wise_action)) && in_array("Wed", json_decode($general->date_wise_action))? 'selected' : ''); ?>>Wednesday</option>
                            <option value="Thu" <?php echo e(is_array(json_decode($general->date_wise_action)) && in_array("Thu", json_decode($general->date_wise_action))? 'selected' : ''); ?>>Thursday</option>
                            <option value="Fri" <?php echo e(is_array(json_decode($general->date_wise_action)) && in_array("Fri", json_decode($general->date_wise_action))? 'selected' : ''); ?>>Friday</option>
                        </select>
                    </div>
                </div>

                <div class="col-md-4">
                    <label class="form-label"><?php echo app('translator')->get('EMAIL VERIFICATION'); ?></label>
                    <div class="onOff-radio-field">
                        <div class="onOff-radio-option">
                            <input type="radio" name="emailver" id="emailver" value="1" <?php if ($general->emailver == 1):echo 'checked'; endif ?>>
                            <label class="bgc-success" for="emailver">ON</label>
                        </div>

                        <div class="onOff-radio-option">
                            <input type="radio" name="emailver" id="emailver1" value="0" <?php if ($general->emailver == 0):echo 'checked'; endif ?>>
                            <label class="bgc-danger" for="emailver1">OFF</label>
                        </div>
                    </div>
                </div>
                
                <div class="form-group col-md-4 ">
                    <label class="font-weight-bold"><?php echo app('translator')->get('Joining bonus'); ?></label>
                    <div class="onOff-radio-field">
                        <div class="onOff-radio-option">
                            <input type="radio" name="joining_bonus" id="joining_bonus" value="1" <?php if ($general->joining_bonus == 1):echo 'checked'; endif ?>>
                            <label class="bgc-success" for="joining_bonus">ON</label>
                        </div>

                        <div class="onOff-radio-option">
                            <input type="radio" name="joining_bonus" id="joining_bonus1" value="0" <?php if ($general->joining_bonus == 0):echo 'checked'; endif ?>>
                            <label class="bgc-danger" for="joining_bonus1">OFF</label>
                        </div>
                    </div>
                </div>
            </div>
            <br>
            <div class="text-center">
                <button type="submit" class="btn s7__btn-primary s7__bg-base mt-2"><?php echo e(__('Update')); ?></button>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/metrqiuu/public_html/resources/views/admin/general/settings.blade.php ENDPATH**/ ?>