
<?php $__env->startSection('title', __('Withdraw Preview')); ?>
<?php $__env->startSection('content'); ?>
<div class="payment-area bg-navy-2 pd-top-90 pd-bottom-90">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="contact-page-inner bg-black-2 contact-page-inner-cust">
                    <form method="POST" action="<?php echo e(route('confirm.withdraw.store')); ?>">
                        <?php echo e(csrf_field()); ?>

                        <?php
                            $charge = ((floatval($amount) * floatval($method->chargepc))/100) + floatval($amount) + floatval($method->chargefx);
                        ?>
                        <input type="hidden" name="amount" value="<?php echo e($amount); ?>" >
                        <input type="hidden" name="method_id" value="<?php echo e($method->id); ?>" >
                            <div class="row">
                                <div class="col-md-4 mt-5">
                                    <div class="thumb mb-4 align-self-center">
                                        <img src="<?php echo e(asset('public/images/withdraw_methods/'.$method->image)); ?>" alt="icon">
                                    </div>
                                </div>

                                <div class="col-md-8">
                                    <div class="facility-details">
                                        <ul class="list-group">
                                            <li class="list-group-item"><?php echo e(__('Request for Withdraw Amount')); ?>: <strong><?php echo e($amount); ?></strong> <?php echo e($general->currency); ?></li>
                                            <li class="list-group-item text-danger"><?php echo e(__('Charge')); ?> : <strong><?php echo e(((floatval($amount) * floatval($method->chargepc))/100)+ floatval($method->chargefx)); ?></strong> <?php echo e($general->currency); ?> | (<?php echo e($method->chargepc); ?> % + <?php echo e($method->chargefx); ?> <?php echo e($general->currency); ?>) </li>
                                            <li class="list-group-item"><?php echo e(__('Total Amount Deduct')); ?>: <strong><?php echo e($charge); ?></strong> <?php echo e($general->currency); ?></li>
                                            <li class="list-group-item text-primary"><?php echo e(__('In')); ?> <?php echo e($method->currency); ?>: <strong><?php echo e(round($amount*$method->rate, 4)); ?></strong> <?php echo e($method->currency); ?></li>
                                            <li class="list-group-item"><?php echo e(__('Payment Gateway')); ?>: <strong><?php echo e($method->name); ?></strong> </li>
                                        </ul>
                                        <div class="text-center">
                                            <strong class="col-md-12"><?php echo e(__('INFORMATION OF WITHDRAW MONEY')); ?></strong>
                                            <textarea class="form-control" name="detail" rows="5" placeholder="<?php echo e(__('Provide all information')); ?>"></textarea>
                                        </div>
                                    </div>
                                    <div class="col-12 text-center mt-3 mb-3">
                                        <input type="submit" class="btn btn-base border-radius-5 pe-5 ps-5" id="btn-confirm" value="<?php echo e(__('Confirm Withdraw')); ?>">
                                    </div>
                                </div>
                            </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make($theme.'frontend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/metrqiuu/public_html/resources/views/theme/deepblack/user/withdraw/preview.blade.php ENDPATH**/ ?>