
<?php $__env->startSection('title',__('Withdraw Request')); ?>
<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body p-0">
            <table class="table s7__table">
                <thead>
                <tr>
                    <th><?php echo app('translator')->get('Withdraw Id'); ?></th>
                    <th><?php echo app('translator')->get('Member Name'); ?></th>
                    <th><?php echo app('translator')->get('Amount Of Withdraw'); ?></th>
                    <th><?php echo app('translator')->get('Method'); ?></th>
                    <th><?php echo app('translator')->get('Amount In Method'); ?></th>
                    <th><?php echo app('translator')->get('Status'); ?></th>
                    <th><?php echo app('translator')->get('Action'); ?></th>

                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $withdraw; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr id="row1">
                        <td> <b><?php echo e($data->withdraw_id); ?></b></td>
                        <td> <?php echo e(optional($data->user)->name); ?></td>
                        <td> <?php echo e($data->amount); ?> <?php echo e($general->currency); ?></td>
                        <td><b><?php echo e($data->method_name); ?> </b></td>
                        <td> <?php echo e(round(floatval($data->amount)*floatval($data->method_rate), 4)); ?> <?php echo e($data->method_cur); ?></td>
                        <td><?php if($data->status == 0): ?>
                                <span class="badge bg-warning text-dark"><?php echo app('translator')->get('Pending'); ?></span>
                            <?php elseif($data->status == 1): ?>
                                <span class="badge bg-success text-dark" ><?php echo app('translator')->get('Paid'); ?></span>
                            <?php else: ?>
                                <span class="badge bg-danger text-dark"><?php echo app('translator')->get('Refunded'); ?></span>
                            <?php endif; ?>
                        </td>
                        <td><a class="btn s7__btn-primary s7__bg-base btn-sm" href="<?php echo e(route('withdraw.detail.user', $data->id)); ?>"><?php echo app('translator')->get('View'); ?></a></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
            <div class="d-flex justify-content-center">
                <?php echo e($withdraw->links('pagination::bootstrap-4')); ?> 
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        (function($) {
            "use strict";
            $(document).ready(function() {
                function disableBack() { window.history.forward() }

                window.onload = disableBack();
                window.onpageshow = function(evt) { if (evt.persisted) disableBack() }
            });
        })(jQuery);
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/metrqiuu/public_html/resources/views/admin/withdraw/withdraw_request.blade.php ENDPATH**/ ?>