<?php $__env->startSection('title',__('Other Wallets Transaction Log')); ?>
<?php $__env->startSection('content'); ?>
<div class="transaction-area pd-top-90 pd-bottom-120">
    <div class="container">
        <div class="table-responsive">
            <table class="table transaction-table">
                <thead>
                <tr>
                    <th> <?php echo e(__('Form User Name')); ?> </th>
                    <th> <?php echo e(__('Form Wallet')); ?> </th>
                    <th> <?php echo e(__('Amount')); ?> </th>
                    <th> <?php echo e(__('Charge')); ?> </th>
                    <th> <?php echo e(__('Type')); ?> </th>
                    <th></th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $transferLog; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if(Auth::id() == $data->form_user_id): ?>
                <tr class="table-margin">
                    <th></th>
                </tr>
                <tr>
                    <td><?php echo e(($data->form_user->name)); ?></td>
                    <td><?php echo e(($data->form_user_wallet->address)); ?></td>
                    <td><?php echo e($data->coin_amount); ?> <?php echo e($general->cp_currency); ?></td>
                    <td><?php echo e($data->charge); ?> <?php echo e($general->cp_currency); ?></td>
                    <td>
                        <?php if($data->status == 0): ?>
                            <span class="badge bg-primary"><?php echo e(__('Panding')); ?></span>
                        <?php elseif($data->status == 1): ?>
                            <span class="badge bg-success"><?php echo e(__('Complete')); ?></span>
                        <?php elseif($data->status == 3): ?>
                            <span class="badge bg-danger"><?php echo e(__('Reject')); ?></span>
                        <?php endif; ?>

                    </td>
                    <td>
                        <?php if($data->status == 0): ?>
                        <button class="btn btn-success btn-sm" data-id="<?php echo e($data->id); ?>" data-bs-toggle="modal" data-bs-target="#acceptModal<?php echo e($data->id); ?>" data-bs-toggle="tooltip" title="<?php echo e(_('Accept')); ?>"> <i class="fa fa-check"></i></button>
                        <button class="btn btn-danger btn-sm" data-id="<?php echo e($data->id); ?>" id="edit" data-bs-toggle="modal" data-bs-target="#cancelModal<?php echo e($data->id); ?>" data-bs-toggle="tooltip" title="<?php echo e(_('Cancel')); ?>"> <i class="fa fa-times"></i></button>
                        <?php endif; ?>
                    </td>
                </tr>
                <div id="acceptModal<?php echo e($data->id); ?>" class="modal fade" tabindex="-1" data-backdrop="static" data-keyboard="false">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title fixTitle"><?php echo e(__('Accept')); ?> <?php echo e($general->cp_currency); ?></h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <form action="<?php echo e(route('confirm-coin-wallet.store', $data->id)); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <div class="modal-body">
                                    <h3 class="text-center text-danger"><?php echo e(__('Received amount')); ?> <?php echo e($data->coin_amount); ?> <?php echo e(__('Charge')); ?> <?php echo e($data->charge); ?> <?php echo e($general->cp_currency); ?></h3>
                                    <p class="text-center text-success"><?php echo e(__('Total amount')); ?> <?php echo e(number_format(floatval($data->coin_amount) + floatval($data->charge), 8)); ?> <?php echo e($general->cp_currency); ?></p>
                                    </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                                    <button type="submit" class="btn btn-success"><?php echo e(__('Confirm')); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <div id="cancelModal<?php echo e($data->id); ?>" class="modal fade" tabindex="-1" data-backdrop="static" data-keyboard="false">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title fixTitle"><?php echo e(__('Reject')); ?> <?php echo e($general->cp_currency); ?></h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <form action="<?php echo e(route('reject-coin-wallet.store', $data->id)); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <div class="modal-body">

                                    <h3 class="text-center text-danger"><?php echo e(__('Received amount')); ?> <?php echo e($data->coin_amount); ?> <?php echo e(__('Charge')); ?> <?php echo e($data->charge); ?> <?php echo e($general->cp_currency); ?></h3>
                                    <p class="text-center text-success"><?php echo e(__('Total amount')); ?> <?php echo e(number_format(floatval($data->coin_amount) + floatval($data->charge), 8)); ?> <?php echo e($general->cp_currency); ?></p>
                                    </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                                    <button type="submit" class="btn btn-success"><?php echo e(__('Confirm')); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
            <div class="row">
                <div class="col-md-12 text-center">
                    <?php echo e($transferLog->links()); ?>

                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($theme.'frontend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/metrqiuu/public_html/resources/views/theme/deepblack/user/wallet/to_log.blade.php ENDPATH**/ ?>