
<?php $__env->startSection('title',__('KYC')); ?>
<?php $__env->startSection('content'); ?>

<div class="contact-area pd-top-90 pd-bottom-120">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-12 col-md-12">
                <div class="contact-page-inner bg-black-2 kyc-contact contact-page-inner-cust">
                    <div class="section-title mb-4 pb-2 text-center">
                        <h2 class="title"><?php echo e(__('KYC Verification')); ?> </h2>
                    </div>
                    <?php if(in_array($user->identity_verify,[0,3])  ): ?>
                    <form method="post" action="<?php echo e(route('user.verificationSubmit')); ?>" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="row justify-content-center">
                            <div class="col-md-6">
                                <div class="single-input-inner">
                                    <label class="form-label d-block w-100" for="identity_type"><?php echo app('translator')->get('Identity Type'); ?></label>
                                    <select name="identity_type" id="identity_type" class="form-select d-block">
                                        <option class="text-white bg-dark" value="" selected disabled><?php echo app('translator')->get('Select Type'); ?></option>
                                        <?php $__currentLoopData = $identityFormList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sForm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option class="text-white bg-dark"
                                                value="<?php echo e($sForm->slug); ?>" <?php echo e(old('identity_type', @$identity_type) == $sForm->slug ? 'selected' : ''); ?>><?php echo app('translator')->get($sForm->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row justify-content-center">
                            <?php if(isset($identityForm)): ?>
                            <?php $__currentLoopData = $identityForm->services_form; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($v->type == "text"): ?>
                            <div class="col-lg-6">
                                <div class="single-input-inner">
                                    <label
                                        for="<?php echo e($k); ?>" class="golden-text"><?php echo e(trans($v->field_level)); ?> <?php if($v->validation == 'required'): ?>
                                            <span class="text-danger">*</span>  <?php endif; ?>
                                    </label>
                                    <input type="text" name="<?php echo e($k); ?>" value="<?php echo e(old($k)); ?>" id="<?php echo e($k); ?>"
                                    <?php if($v->validation == 'required'): ?> required <?php endif; ?>>
                                    <?php if($errors->has($k)): ?>
                                        <div class="error text-danger"><?php echo app('translator')->get($errors->first($k)); ?> </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class="row justify-content-center">
                            <?php elseif($v->type == "textarea"): ?>
                            <div class="col-lg-6">
                                <div class="single-input-inner">
                                    <label
                                        for="<?php echo e($k); ?>" class="golden-text"><?php echo e(trans($v->field_level)); ?> <?php if($v->validation == 'required'): ?>
                                            <span
                                                class="text-danger">*</span>  <?php endif; ?>
                                    </label>
                                    <textarea name="<?php echo e($k); ?>" id="<?php echo e($k); ?>"
                                            rows="5"
                                            placeholder="<?php echo e(trans('Type Here')); ?>"
                                            <?php if($v->validation == 'required'): ?><?php endif; ?>><?php echo e(old($k)); ?></textarea>
                                    <?php $__errorArgs = [$k];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="error text-danger">
                                        <?php echo e(trans($message)); ?>

                                    </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>
                        <div class="row justify-content-center">
                            <?php elseif($v->type == "file"): ?>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label class="golden-text"><?php echo e(trans($v->field_level)); ?> <?php if($v->validation == 'required'): ?>
                                            <span class="text-danger">*</span>  <?php endif; ?>
                                    </label>
                                    <br>
                                    <input type="file" id="file-input" class="form-control" name="<?php echo e($k); ?>"
                                    value="<?php echo e(old($k)); ?>" accept="image/*"
                                    <?php if($v->validation == "required"): ?><?php endif; ?>>
                                    <div class="row mt-2">
                                        <div class="col-md-12">
                                            <div id='img_contain'>
                                                <img id="image-preview" class="img-fluid" align='middle' src="<?php echo e(getFile(config('location.default'))); ?>" alt="your image" title=''/>
                                            </div>
                                        </div>
                                    </div>
                                    <?php $__errorArgs = [$k];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="error text-danger">
                                        <?php echo e(trans($message)); ?>

                                    </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <?php endif; ?>
    
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <div class="row justify-content-center">
                            <div class="col-12 text-center send-btn mt-3 mb-3">
                                <button type="submit" class="btn btn-base border-radius-5 pe-5 ps-5"><?php echo e(__('Submit')); ?></button>
                            </div>
                            <?php endif; ?>
                        </div>
                    </form>
                    <?php elseif($user->identity_verify == 1): ?>
                        <div class="alert mb-0 text-center">
                            <img src="<?php echo e(asset('public/images/notification.png')); ?>" alt="<?php echo app('translator')->get('notification img'); ?>"/>
                            <span> <?php echo app('translator')->get('Your KYC submission has been pending'); ?></span>
                        </div>
                    <?php elseif($user->identity_verify == 2): ?>
                        <div class="alert mb-0 text-center">
                            <img src="<?php echo e(asset('public/images/notification.png')); ?>" alt="<?php echo app('translator')->get('notification img'); ?>"/>
                            <span> <?php echo app('translator')->get('Your KYC already verified'); ?></span>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        "use strict";
            function readURL(input) {
                if (input.files && input.files[0]) {
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        $('#image-preview').attr('src', e.target.result);
                        $('#image-preview').hide();
                        $('#image-preview').fadeIn(650);
                    };
                    reader.readAsDataURL(input.files[0]);
                }
            }
            $("#file-input").on('change',function() {
                readURL(this);
            });


        $(document).on('change', "#identity_type", function () {
            let value = $(this).find('option:selected').val();
            window.location.href = "<?php echo e(route('user.kyc.index')); ?>/?identity_type=" + value
        });

    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make($theme.'frontend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/metrqiuu/public_html/resources/views/theme/deepblack/user/kyc.blade.php ENDPATH**/ ?>