<?php $__env->startSection('title',__('Dashboard')); ?>
<?php $__env->startSection('content'); ?>

<div class="row gy-4">
  <div class="col-lg-3">
    <div class="s7__widget-three">
      <div class="content">
        <p class="mb-2"><?php echo e(__('Total Users')); ?></p>
        <h3 class="mb-0"><?php echo e($total_user); ?></h3>
      </div>
      <div class="icon s7__bg-primary rounded-circle">
        <i class="las la-users"></i>
      </div>
    </div>
  </div>
  <div class="col-lg-3">
    <div class="s7__widget-three">
      <div class="content">
        <p class="mb-2"><?php echo e(__('Active Users')); ?></p>
        <h3 class="mb-0"><?php echo e($total_ac_user); ?></h3>
      </div>
      <div class="icon s7__bg-primary rounded-circle">
        <i class="las la-user-plus"></i>
      </div>
    </div>
  </div>
  <div class="col-lg-3">
    <div class="s7__widget-three">
      <div class="content">
        <p class="mb-2"><?php echo e(__('Banned Users')); ?></p>
        <h3 class="mb-0"><?php echo e($total_bn_user); ?></h3>
      </div>
      <div class="icon s7__bg-primary rounded-circle">
        <i class="las la-user-times"></i>
      </div>
    </div>
  </div>
  <div class="col-lg-3">
    <div class="s7__widget-three">
      <div class="content">
        <p class="mb-2"><?php echo e(__('Today Join User')); ?></p>
        <h3 class="mb-0"><?php echo e($userRecord['todayJoin']); ?></h3>
      </div>
      <div class="icon s7__bg-primary rounded-circle">
        <i class="las la-user"></i>
      </div>
    </div>
  </div>
</div>

<div class="row gy-4 mt-3">
  <div class="col-lg-3">
    <div class="s7__widget-three">
      <div class="content">
        <p class="mb-2"><?php echo e(__('Today Invest')); ?></p>
        <h3 class="mb-0"><?php echo e($today_invest); ?></h3>
      </div>
      <div class="icon s7__bg-primary rounded-circle">
        <i class="las la-wallet"></i>
      </div>
    </div>
  </div>
  <div class="col-lg-3">
    <div class="s7__widget-three">
      <div class="content">
        <p class="mb-2"><?php echo e(__('Running Invest')); ?></p>
        <h3 class="mb-0"><?php echo e($running_invest); ?></h3>
      </div>
      <div class="icon s7__bg-primary rounded-circle">
        <i class="las la-hand-holding-usd"></i>
      </div>
    </div>
  </div>
  <div class="col-lg-3">
    <div class="s7__widget-three">
      <div class="content">
        <p class="mb-2"><?php echo e(__('Complete Invest')); ?></p>
        <h3 class="mb-0"><?php echo e($complete_invest); ?></h3>
      </div>
      <div class="icon s7__bg-primary rounded-circle">
        <i class="las la-calendar-check"></i>
      </div>
    </div>
  </div>
  <div class="col-lg-3">
    <div class="s7__widget-three">
      <div class="content">
        <p class="mb-2"><?php echo e(__('Total Invest')); ?></p>
        <h3 class="mb-0"><?php echo e(round($total_invest,2)); ?> <?php echo e($general->currency); ?></h3>
      </div>
      <div class="icon s7__bg-primary rounded-circle">
        <i class="las la-coins"></i>
      </div>
    </div>
  </div>
</div>

<div class="row gy-4 mt-3">
  <div class="col-lg-3">
    <div class="s7__widget-three">
      <div class="content">
        <p class="mb-2"><?php echo e(__('Total Plans')); ?></p>
        <h3 class="mb-0"><?php echo e($total_plan); ?></h3>
      </div>
      <div class="icon s7__bg-primary rounded-circle">
        <i class="las la-clipboard-list"></i>
      </div>
    </div>
  </div>
  <div class="col-lg-3">
    <div class="s7__widget-three">
      <div class="content">
        <p class="mb-2"><?php echo e(__('Total Interest')); ?></p>
        <h3 class="mb-0"><?php echo e($total_earn); ?></h3>
      </div>
      <div class="icon s7__bg-primary rounded-circle">
        <i class="las la-money-bill"></i>
      </div>
    </div>
  </div>
  <div class="col-lg-3">
    <div class="s7__widget-three">
      <div class="content">
        <p class="mb-2"><?php echo e(__('Today\'s Deposit')); ?></p>
        <h3 class="mb-0"><?php echo e(round($today_deposit,2)); ?> <?php echo e($general->currency); ?></h3>
      </div>
      <div class="icon s7__bg-primary rounded-circle">
        <i class="las la-seedling"></i>
      </div>
    </div>
  </div>
  <div class="col-lg-3">
    <div class="s7__widget-three">
      <div class="content">
        <p class="mb-2"><?php echo e(__('Total Deposit')); ?></p>
        <h3 class="mb-0"><?php echo e(round($total_deposit,2)); ?> <?php echo e($general->currency); ?></h3>
      </div>
      <div class="icon s7__bg-primary rounded-circle">
        <i class="las la-coins"></i>
      </div>
    </div>
  </div>
</div>

<div class="row gy-4 mt-3">
  <div class="col-lg-3">
    <div class="s7__widget-three">
      <div class="content">
        <p class="mb-2"><?php echo e(__('Today Withdraw')); ?></p>
        <h3 class="mb-0"><?php echo e(round($today_withdraw,2)); ?> <?php echo e($general->currency); ?></h3>
      </div>
      <div class="icon s7__bg-primary rounded-circle">
        <i class="las la-money-bill-wave"></i>
      </div>
    </div>
  </div>
  <div class="col-lg-3">
    <div class="s7__widget-three">
      <div class="content">
        <p class="mb-2"><?php echo e(__('Total Withdraw')); ?></p>
        <h3 class="mb-0"><?php echo e(round($total_withdraw,2)); ?> <?php echo e($general->currency); ?></h3>
      </div>
      <div class="icon s7__bg-primary rounded-circle">
        <i class="las la-hand-holding-usd"></i>
      </div>
    </div>
  </div>
  <div class="col-lg-3">
    <div class="s7__widget-three">
      <div class="content">
        <p class="mb-2"><?php echo e(__('Pending Withdraw')); ?></p>
        <h3 class="mb-0"><?php echo e($panding_withdraw); ?></h3>
      </div>
      <div class="icon s7__bg-primary rounded-circle">
        <i class="las la-spinner"></i>
      </div>
    </div>
  </div>
  <div class="col-lg-3">
    <div class="s7__widget-three">
      <div class="content">
        <p class="mb-2"><?php echo e(__('Reject Withdraw')); ?></p>
        <h3 class="mb-0"><?php echo e($reject_withdraw); ?></h3>
      </div>
      <div class="icon s7__bg-primary rounded-circle">
        <i class="las la-times-circle"></i>
      </div>
    </div>
  </div>
</div>

<div class="row">
  <div class="col-lg-6">
      <div class="card mt-4">
        <div class="card-body">
            <div id="chart3"></div>
        </div>
      </div>
  </div>
  <div class="col-lg-6">
      <div class="card mt-4">
        <div class="card-body">
            <div id="chart"></div>
        </div>
      </div>
  </div>
</div>



<div class="row gy-4 mt-2">
  <div class="col-xxl-3 col-sm-6">
    <div class="s7__widget-two">
      <div class="icon">
        <i class="las la-hand-holding-usd"></i>
      </div>
      <div class="content">
        <p class="caption"><?php echo e(__('This Month Invest')); ?></p>
        <h3 class="amount"><?php echo e(round($total_invest_month,2)); ?> <?php echo e($general->currency); ?></h3>
      </div>
    </div>
  </div>
  <div class="col-xxl-3 col-sm-6">
    <div class="s7__widget-two">
      <div class="icon">
        <i class="las la-hand-holding-usd"></i>
      </div>
      <div class="content">
        <p class="caption"><?php echo e(__('This Month Deposit')); ?></p>
        <h3 class="amount"><?php echo e(round($total_deposit_month,2)); ?> <?php echo e($general->currency); ?></h3>
      </div>
    </div>
  </div>
  <div class="col-xxl-3 col-sm-6">
    <div class="s7__widget-two">
      <div class="icon">
        <i class="las la-hand-holding-usd"></i>
      </div>
      <div class="content">
        <p class="caption"><?php echo e(__('This Month Withdraw')); ?></p>
        <h3 class="amount"><?php echo e(round($total_withdraw_month,2)); ?> <?php echo e($general->currency); ?></h3>
      </div>
    </div>
  </div>
  <div class="col-xxl-3 col-sm-6">
    <div class="s7__widget-two">
      <div class="icon">
        <i class="las la-hand-holding-usd"></i>
      </div>
      <div class="content">
        <p class="caption"><?php echo e(__('This Month Profit')); ?></p>
        <h3 class="amount"><?php echo e(round($month_earn,2)); ?> <?php echo e($general->currency); ?></h3>
      </div>
    </div>
  </div>
</div>

<div class="card mt-5">
  <div class="card-header border-0">
      <div class="d-flex flex-wrap justify-content-between align-items-center">
          <h6 class="text-uppercase mb-0"><?php echo e(__('Latest User')); ?></h6>
      </div>
  </div>
  <div class="card-body p-0">
    <table class="table s7__table">
        <thead>
            <tr>
              <th><?php echo e(__('Name')); ?></th>
              <th><?php echo e(__('Email')); ?></th>
              <th><?php echo e(__('Balance')); ?></th>
              <th><?php echo e(__('Status')); ?></th>
              <th><?php echo e(__('Action')); ?></th>
            </tr>
        </thead>
        <tbody>
          <?php $__currentLoopData = $latestUser; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <tr>
            <td data-caption="customer">
              <div class="content">
                <h6 class="text-small mb-0"><?php echo app('translator')->get($data->name); ?></h6>
              </div>
            </td>
            <td data-caption="Product"><?php echo app('translator')->get($data->email); ?></td>
            <td data-caption="Date"><?php echo e(getAmount($data->balance)); ?> <?php echo e($general->currency); ?></td>
            <td data-caption="Status">
              <?php if($data->status == 1): ?>
                  <span class="s7__badge s7__badge-success"><?php echo app('translator')->get('Active'); ?></span>
              <?php else: ?>
                  <span class="s7__badge s7__badge-danger"><?php echo app('translator')->get('Inactive'); ?></span>
              <?php endif; ?>
            </td>
            <td data-caption="Action">
              <a href="<?php echo e(route('user.view', $data->id)); ?>" class="table-icon s7__text-secondary"><i class="las la-edit"></i></a>
            </td>
          </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
  </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>

<script>

var options = {
    series: [{
      name: "Total Investment",
      data: [
        <?php $__currentLoopData = $months; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $totalInvestment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php echo e(@$investMonth->where('months', $totalInvestment)->first()->amount ?? 0); ?>,
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      ]
  }, {
    name: 'Total Interest',
    data: [
      <?php $__currentLoopData = $months; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $totalInterest): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <?php echo e(@$interestMonth->where('months', $totalInterest)->first()->amount ?? 0); ?>,
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    ]
  }],
    chart: {
    height: 350,
    type: 'line',
    zoom: {
      enabled: false
    }
  },
  dataLabels: {
    enabled: false
  },
  stroke: {
    curve: 'straight'
  },
  title: {
    text: 'Plan Statistics (Last 12 Month)',
    align: 'left'
  },
  grid: {
    row: {
      colors: ['#f3f3f3', 'transparent'],
      opacity: 0.5
    },
  },
  xaxis: {
    categories:  <?php echo json_encode($months, 15, 512) ?>,
  }
};

  var chart = new ApexCharts(document.querySelector("#chart"), options);
  chart.render();


  var options = {
      series: [{
      name: 'Total Deposit',
      data: [
        <?php $__currentLoopData = $months; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $depositMonth): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php echo e(getAmount(@$depositsMonth->where('months', $depositMonth)->first()->depositAmount)); ?>,
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        ]
    }, {
      name: 'Total Withdraw',
      data: [
        <?php $__currentLoopData = $months; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $withdrawMonth): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php echo e(getAmount(@$withdrawalMonth->where('months', $withdrawMonth)->first()->withdrawAmount)); ?>,
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      ]
    }],
      chart: {
      type: 'bar',
      height: 350,
      toolbar: {
          show: false
      }
    },
    title: {
      text: 'Monthly Deposit & Withdraw Report (Last 12 Month)',
      align: 'left'
    },
    plotOptions: {
      bar: {
        horizontal: false,
        columnWidth: '55%',
        endingShape: 'rounded'
      },
    },
    dataLabels: {
      enabled: false
    },
    stroke: {
      show: true,
      width: 2,
      colors: ['transparent']
    },
    xaxis: {
      categories: <?php echo json_encode($months, 15, 512) ?>,
    },
    fill: {
      opacity: 1
    },
    tooltip: {
      y: {
        formatter: function (val) {
          return "<?php echo e(__($general->currency)); ?> " + val + " "
        }
      }
    }
  };

  var chart3 = new ApexCharts(document.querySelector("#chart3"), options);
  chart3.render();

</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/metrqiuu/public_html/resources/views/admin/home.blade.php ENDPATH**/ ?>