<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TransferLog extends Model
{
    use HasFactory;
    protected $guarded = ['id'];

    public function form_user(){
        return $this->belongsTo(User::class, 'form_user_id')->withDefault();
    }

    public function form_user_wallet(){
        return $this->belongsTo(Wallet::class, 'from_wallet_id')->withDefault();
    }

    public function to_user(){
        return $this->belongsTo(User::class, 'to_user_id')->withDefault();
    }

    public function to_user_wallet(){
        return $this->belongsTo(Wallet::class, 'to_wallet_id')->withDefault();
    }
}
