@extends('admin.layouts.master')
@section('title',__('Faqs Edit'))
@section('content')

    <div class="card">
        <div class="card-header">
            <h2>@lang('Edit')</h2>
        </div>

        <div class="card-body">
            <form action="{{route('faq.update',$faq->id)}}" method="POST">
                @csrf
                @method('put')
                <div class="form-row">
                    <div class="form-group col-md-12">
                        <label>@lang('Question')</label>
                        <input type="text" class="form-control" name="question" value="{{$faq->question}}" required>
                    </div>

                    <div class="form-group col-md-12">
                        <label >@lang('Answer')</label>
                        <textarea class="form-control" name="answer" id="edit_faqs" rows="10" required>{!! $faq->answer !!}</textarea>
                    </div>

                </div>
                <<div class="text-center">
                    <button type="submit" class="btn s7__btn-primary s7__bg-base mt-2">@lang('Update')</button>
                </div>
            </form>
        </div>
    </div>
@endsection
