@extends('admin.layouts.master')
@section('title',__('Faqs'))
@section('content')
    <div class="card">
        <div class="card-header">
            <h2>@lang('Faqs') <a href="{{route('faq.create')}}" class="btn btn-success btn-sm float-end"><i class="fa fa-plus"></i> @lang('Add New')</a></h2>
        </div>

        <div class="card-body p-0">
            <table class="table s7__table">
                <thead>
                <tr>
                    <th>{{__('SL')}}</th>
                    <th>{{__('Question')}}</th>
                    <th>{{__('Action')}}</th>
                </tr>
                </thead>
                <tbody>
                @foreach ($faq as $key => $data)
                <tr>
                    <td>{{$key+1}}</td>
                    <td>{{$data->question}}</td>
                    <td>
                        <a href="{{route('faq.edit', $data->id)}}" class="btn btn-primary btn-sm">@lang('View/Edit')</a>
                        <a href="#delModal" data-route="{{route('faq.destroy', $data->id)}}" data-toggle="modal" class="btn btn-danger btn-sm editButton">@lang('Delete')</a>
                    </td>
                </tr>
                @endforeach
                </tbody>
            </table>

        </div>
    </div>

    <div id="delModal" class="modal fade" tabindex="-1" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Confirm Delete')</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="confirmDel" role="form" action="" method="post">
                    @csrf
                    @method('delete')
                    <div class="modal-body">
                        <h2 class="text-danger">@lang('Are you sure?')</h2>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">@lang('Close')</button>
                        <button type="submit" class="btn btn-danger">@lang('Delete')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

@endsection
@section('script')
<script>
    (function($) {
        "use strict";
            $(document).ready(function () {
                $('.editButton').on('click',function () {
                    $('#confirmDel').attr('action',$(this).data('route'));
                });
            });
		})(jQuery);
    </script>
@endsection
