@extends($theme.'frontend.layouts.master')
@section('title',__('Register From Here'))
@section('content')

<div class="contact-area pd-top-120 pd-bottom-120">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-6 col-md-8 col-12 mx-auto mb-50">
                <img src="{{__('public/images/login.png')}}" alt="img">
            </div>
            <div class="col-lg-5 col-md-8 col-12 mx-auto mb-50">
                <div class="contact-page-inner contact-page-inner-cust">
                    <div class="section-title mb-4 pb-2 text-center">
                        <h2 class="title">{{__('Register')}} </h2>
                    </div>
                    <form method="POST" action="{{ route('register') }}">
                        @csrf
                        <div class="row">
                            @isset($refName)
                                <div class="col-md-12">
                                    <label>{{__('Referrer Name')}} :</label>
                                    <input type="text" disabled value="{{$refName->name}}">
                                </div>
                                <input type="hidden" value="{{$refName->id}}" name="ref_id">
                            @endisset
                            <div class="col-md-12">
                                <div class="single-input-inner">
                                    <label>{{__('Full Name')}} :</label>
                                    <input type="text" name="name" required value="{{old('name')}}" autocomplete="name" autofocus>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="single-input-inner">
                                    <label>{{__('Email')}} :</label>
                                    <input type="email" name="email" required autocomplete="email" value="{{old('email')}}" autofocus>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="single-input-inner">
                                    <label>{{__('Password')}} :</label>
                                    <input type="password" name="password" required>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="single-input-inner">
                                    <label>{{__('Confirm Password')}} :</label>
                                    <input type="password" name="password_confirmation" required>
                                </div>
                            </div>
                            <div class="col-12 text-center mt-3 mb-3">
                                <button type="submit" class="btn btn-base border-radius-5 pe-5 ps-5">{{__('Register')}}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
