<!DOCTYPE html>
<html lang="zxx">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php echo e(__($general->web_name)); ?> | <?php echo $__env->yieldContent(__('title')); ?></title>
    <link rel=icon href="<?php echo e(asset('public/images/logo/favicon.png')); ?>" sizes="20x20" type="image/png">

    <?php echo $__env->make($theme.'frontend.layouts.partials.style', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldContent('style'); ?>

</head>
<body>

    <div class="preloader" id="preloader">
        <div class="preloader-inner">
            <div class="spinner">
                <div class="dot1"></div>
                <div class="dot2"></div>
            </div>
        </div>
    </div>

    <?php echo $__env->make($theme.'frontend.layouts.partials.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make($theme.'frontend.layouts.slider', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->yieldContent('content'); ?>

    <?php echo $__env->make($theme.'frontend.layouts.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make($theme.'frontend.layouts.partials.script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldContent('script'); ?>

    <?php if($errors->any()): ?>
    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <script>
            (function($) {
                "use strict";
            toastr.warning('<?php echo e($error); ?>')
            })(jQuery);
        </script>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
    <?php if(Session::has('message')): ?>
    <script>
        (function($) {
        "use strict";
        toastr.success('<?php echo e(Session::get('message')); ?>');
        })(jQuery);
    </script>
    <?php endif; ?>
    <?php if(session()->has('success')): ?>
    <script>
        (function($) {
                "use strict";
                toastr.success('<?php echo e(session()->get('success')); ?>')
        })(jQuery);
    </script>
    <?php endif; ?>
    <?php if(session()->has('alert')): ?>
    <script>
    (function($) {
            "use strict";
            toastr.error('<?php echo e(session()->get('alert')); ?>')
        })(jQuery);
    </script>
    <?php endif; ?>
    
</body>
</html><?php /**PATH D:\laragon\www\investpro_2023\resources\views/theme/deepblack/frontend/layouts/master.blade.php ENDPATH**/ ?>